package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VfichaOs2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaOs2DaoImpl generated by UDA, 27-jun-2017 10:39:49.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VfichaOs2DaoImpl implements VfichaOs2Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VfichaOs2> rwMap = new RowMapper<VfichaOs2>() {
		public VfichaOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaOs2(resultSet.getString("NUMEXP"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("NUMERODOCUMENTOEMPRESA"),
					resultSet.getString("CENAEDESCRIPCION"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("NOREALIZATRABAJOANEXOIEMPRESA"),
					resultSet.getString("REALIZATRABAJOANEXOIEMPRESA"),
					resultSet.getString("TRABAJOANEXOIEMPRESA"),
					resultSet.getString("DIRECCIONEMPRESA"),
					resultSet.getInt("PLANTILLATOTALEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("MUNOICIPIOEMPRESA"),
					resultSet.getString("EMAILEMPRESA"),
					resultSet.getString("HTTPEMPRESA"),
					resultSet.getString("FAXEMPRESA"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("DOMICILIODIRECCIONCENTRO"),
					resultSet.getString("MUNICIPIODIRECCIONCENTRO"),
					resultSet.getString("THDIRECCIONCENTRO"),
					resultSet.getString("NUMEROAPERTURA"),
					resultSet.getString("TIPMPR1"),
					resultSet.getString("TIPMPR2"),
					resultSet.getString("NOMMPR1"),
					resultSet.getString("NOMMPR2"),
					resultSet.getString("TOPSEG1"),
					resultSet.getString("TOPSEG2"),
					resultSet.getString("TOPHIG1"),
					resultSet.getString("TOPHIG2"),
					resultSet.getString("TOPER1"),
					resultSet.getString("TOPER2"),
					resultSet.getString("TOPVIG1"),
					resultSet.getString("TOPVIG2"),
					resultSet.getString("TIPRIE1"),
					resultSet.getString("TIPRIE2"),
					resultSet.getString("NOMRIE1"),
					resultSet.getString("NOMRIE2"),
					resultSet.getString("AUDITORIANOREALIZADA"),
					resultSet.getString("AUDITORIAREALIZADA"),
					resultSet.getDate("FECHAULTIMAREALIZACION"),
					resultSet.getString("EMPRESAAUDITORA"));
		}
	};

	private RowMapper<VfichaOs2> rwMapPK = new RowMapper<VfichaOs2>() {
		public VfichaOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaOs2(resultSet.getString("NUMEXP"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("NUMERODOCUMENTOEMPRESA"),
					resultSet.getString("CENAEDESCRIPCION"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("NOREALIZATRABAJOANEXOIEMPRESA"),
					resultSet.getString("REALIZATRABAJOANEXOIEMPRESA"),
					resultSet.getString("TRABAJOANEXOIEMPRESA"),
					resultSet.getString("DIRECCIONEMPRESA"),
					resultSet.getInt("PLANTILLATOTALEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("MUNOICIPIOEMPRESA"),
					resultSet.getString("EMAILEMPRESA"),
					resultSet.getString("HTTPEMPRESA"),
					resultSet.getString("FAXEMPRESA"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("DOMICILIODIRECCIONCENTRO"),
					resultSet.getString("MUNICIPIODIRECCIONCENTRO"),
					resultSet.getString("THDIRECCIONCENTRO"),
					resultSet.getString("NUMEROAPERTURA"),
					resultSet.getString("TIPMPR1"),
					resultSet.getString("TIPMPR2"),
					resultSet.getString("NOMMPR1"),
					resultSet.getString("NOMMPR2"),
					resultSet.getString("TOPSEG1"),
					resultSet.getString("TOPSEG2"),
					resultSet.getString("TOPHIG1"),
					resultSet.getString("TOPHIG2"),
					resultSet.getString("TOPER1"),
					resultSet.getString("TOPER2"),
					resultSet.getString("TOPVIG1"),
					resultSet.getString("TOPVIG2"),
					resultSet.getString("TIPRIE1"),
					resultSet.getString("TIPRIE2"),
					resultSet.getString("NOMRIE1"),
					resultSet.getString("NOMRIE2"),
					resultSet.getString("AUDITORIANOREALIZADA"),
					resultSet.getString("AUDITORIAREALIZADA"),
					resultSet.getDate("FECHAULTIMAREALIZACION"),
					resultSet.getString("EMPRESAAUDITORA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VfichaOs2 table.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @return the vficha os 2
	 */
	public VfichaOs2 add(VfichaOs2 vfichaos2) {
		String query = "INSERT INTO VFICHA_OS2 (NUMEXP, RAZONSOCIAL, NUMERODOCUMENTOEMPRESA, CENAEDESCRIPCION, ACTIVIDADECONOMICA, NOREALIZATRABAJOANEXOIEMPRESA, REALIZATRABAJOANEXOIEMPRESA, TRABAJOANEXOIEMPRESA, DIRECCIONEMPRESA, PLANTILLATOTALEMPRESA, TERRITORIOEMPRESA, CP, MUNOICIPIOEMPRESA, EMAILEMPRESA, HTTPEMPRESA, FAXEMPRESA, TELEFONOEMPRESA, DOMICILIODIRECCIONCENTRO, MUNICIPIODIRECCIONCENTRO, THDIRECCIONCENTRO, NUMEROAPERTURA, TIPMPR1, TIPMPR2, NOMMPR1, NOMMPR2, TOPSEG1, TOPSEG2, TOPHIG1, TOPHIG2, TOPER1, TOPER2, TOPVIG1, TOPVIG2, TIPRIE1, TIPRIE2, NOMRIE1, NOMRIE2, AUDITORIANOREALIZADA, AUDITORIAREALIZADA, FECHAULTIMAREALIZACION, EMPRESAAUDITORA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vfichaos2.getNumexp(),
				vfichaos2.getRazonsocial(),
				vfichaos2.getNumerodocumentoempresa(),
				vfichaos2.getCenaedescripcion(),
				vfichaos2.getActividadeconomica(),
				vfichaos2.getNorealizatrabajoanexoiempresa(),
				vfichaos2.getRealizatrabajoanexoiempresa(),
				vfichaos2.getTrabajoanexoiempresa(),
				vfichaos2.getDireccionempresa(),
				vfichaos2.getPlantillatotalempresa(),
				vfichaos2.getTerritorioempresa(), vfichaos2.getCp(),
				vfichaos2.getMunoicipioempresa(), vfichaos2.getEmailempresa(),
				vfichaos2.getHttpempresa(), vfichaos2.getFaxempresa(),
				vfichaos2.getTelefonoempresa(),
				vfichaos2.getDomiciliodireccioncentro(),
				vfichaos2.getMunicipiodireccioncentro(),
				vfichaos2.getThdireccioncentro(),
				vfichaos2.getNumeroapertura(), vfichaos2.getTipmpr1(),
				vfichaos2.getTipmpr2(), vfichaos2.getNommpr1(),
				vfichaos2.getNommpr2(), vfichaos2.getTopseg1(),
				vfichaos2.getTopseg2(), vfichaos2.getTophig1(),
				vfichaos2.getTophig2(), vfichaos2.getToper1(),
				vfichaos2.getToper2(), vfichaos2.getTopvig1(),
				vfichaos2.getTopvig2(), vfichaos2.getTiprie1(),
				vfichaos2.getTiprie2(), vfichaos2.getNomrie1(),
				vfichaos2.getNomrie2(), vfichaos2.getAuditorianorealizada(),
				vfichaos2.getAuditoriarealizada(),
				vfichaos2.getFechaultimarealizacion(),
				vfichaos2.getEmpresaauditora());
		return vfichaos2;
	}

	/**
	 * Updates a single row in the VfichaOs2 table.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @return the vficha os 2
	 */
	public VfichaOs2 update(VfichaOs2 vfichaos2) {
		String query = "UPDATE VFICHA_OS2 SET  WHERE NUMEXP=? AND RAZONSOCIAL=? AND NUMERODOCUMENTOEMPRESA=? AND CENAEDESCRIPCION=? AND ACTIVIDADECONOMICA=? AND NOREALIZATRABAJOANEXOIEMPRESA=? AND REALIZATRABAJOANEXOIEMPRESA=? AND TRABAJOANEXOIEMPRESA=? AND DIRECCIONEMPRESA=? AND PLANTILLATOTALEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND MUNOICIPIOEMPRESA=? AND EMAILEMPRESA=? AND HTTPEMPRESA=? AND FAXEMPRESA=? AND TELEFONOEMPRESA=? AND DOMICILIODIRECCIONCENTRO=? AND MUNICIPIODIRECCIONCENTRO=? AND THDIRECCIONCENTRO=? AND NUMEROAPERTURA=? AND TIPMPR1=? AND TIPMPR2=? AND NOMMPR1=? AND NOMMPR2=? AND TOPSEG1=? AND TOPSEG2=? AND TOPHIG1=? AND TOPHIG2=? AND TOPER1=? AND TOPER2=? AND TOPVIG1=? AND TOPVIG2=? AND TIPRIE1=? AND TIPRIE2=? AND NOMRIE1=? AND NOMRIE2=? AND AUDITORIANOREALIZADA=? AND AUDITORIAREALIZADA=? AND FECHAULTIMAREALIZACION=? AND EMPRESAAUDITORA=?";
		this.jdbcTemplate.update(query, vfichaos2.getNumexp(),
				vfichaos2.getRazonsocial(),
				vfichaos2.getNumerodocumentoempresa(),
				vfichaos2.getCenaedescripcion(),
				vfichaos2.getActividadeconomica(),
				vfichaos2.getNorealizatrabajoanexoiempresa(),
				vfichaos2.getRealizatrabajoanexoiempresa(),
				vfichaos2.getTrabajoanexoiempresa(),
				vfichaos2.getDireccionempresa(),
				vfichaos2.getPlantillatotalempresa(),
				vfichaos2.getTerritorioempresa(), vfichaos2.getCp(),
				vfichaos2.getMunoicipioempresa(), vfichaos2.getEmailempresa(),
				vfichaos2.getHttpempresa(), vfichaos2.getFaxempresa(),
				vfichaos2.getTelefonoempresa(),
				vfichaos2.getDomiciliodireccioncentro(),
				vfichaos2.getMunicipiodireccioncentro(),
				vfichaos2.getThdireccioncentro(),
				vfichaos2.getNumeroapertura(), vfichaos2.getTipmpr1(),
				vfichaos2.getTipmpr2(), vfichaos2.getNommpr1(),
				vfichaos2.getNommpr2(), vfichaos2.getTopseg1(),
				vfichaos2.getTopseg2(), vfichaos2.getTophig1(),
				vfichaos2.getTophig2(), vfichaos2.getToper1(),
				vfichaos2.getToper2(), vfichaos2.getTopvig1(),
				vfichaos2.getTopvig2(), vfichaos2.getTiprie1(),
				vfichaos2.getTiprie2(), vfichaos2.getNomrie1(),
				vfichaos2.getNomrie2(), vfichaos2.getAuditorianorealizada(),
				vfichaos2.getAuditoriarealizada(),
				vfichaos2.getFechaultimarealizacion(),
				vfichaos2.getEmpresaauditora());
		return vfichaos2;
	}

	/**
	 * Finds a single row in the VfichaOs2 table.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @return the vficha os 2
	 */
	@Transactional(readOnly = true)
	public VfichaOs2 find(VfichaOs2 vfichaos2) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.RAZONSOCIAL RAZONSOCIAL, t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA, t1.CENAEDESCRIPCION CENAEDESCRIPCION, t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA, t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA, t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA, t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA, t1.DIRECCIONEMPRESA DIRECCIONEMPRESA, t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA, t1.TERRITORIOEMPRESA TERRITORIOEMPRESA, t1.CP CP, t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA, t1.EMAILEMPRESA EMAILEMPRESA, t1.HTTPEMPRESA HTTPEMPRESA, t1.FAXEMPRESA FAXEMPRESA, t1.TELEFONOEMPRESA TELEFONOEMPRESA, t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO, t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO, t1.THDIRECCIONCENTRO THDIRECCIONCENTRO, t1.NUMEROAPERTURA NUMEROAPERTURA, t1.TIPMPR1 TIPMPR1, t1.TIPMPR2 TIPMPR2, t1.NOMMPR1 NOMMPR1, t1.NOMMPR2 NOMMPR2, t1.TOPSEG1 TOPSEG1, t1.TOPSEG2 TOPSEG2, t1.TOPHIG1 TOPHIG1, t1.TOPHIG2 TOPHIG2, t1.TOPER1 TOPER1, t1.TOPER2 TOPER2, t1.TOPVIG1 TOPVIG1, t1.TOPVIG2 TOPVIG2, t1.TIPRIE1 TIPRIE1, t1.TIPRIE2 TIPRIE2, t1.NOMRIE1 NOMRIE1, t1.NOMRIE2 NOMRIE2, t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA, t1.AUDITORIAREALIZADA AUDITORIAREALIZADA, t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION, t1.EMPRESAAUDITORA EMPRESAAUDITORA FROM VFICHA_OS2 t1  WHERE t1.NUMEXP = ?  ";

		List<VfichaOs2> vfichaos2List = this.jdbcTemplate.query(query,
				this.rwMap, vfichaos2.getNumexp());
		return (VfichaOs2) DataAccessUtils.uniqueResult(vfichaos2List);
	}

	/**
	 * Removes a single row in the VfichaOs2 table.
	 * 
	 *  vfichaos2            VfichaOs2
	 *
	 * @param vfichaos2 the vfichaos 2
	 */
	public void remove(VfichaOs2 vfichaos2) {
		String query = "DELETE FROM VFICHA_OS2 WHERE NUMEXP=? AND RAZONSOCIAL=? AND NUMERODOCUMENTOEMPRESA=? AND CENAEDESCRIPCION=? AND ACTIVIDADECONOMICA=? AND NOREALIZATRABAJOANEXOIEMPRESA=? AND REALIZATRABAJOANEXOIEMPRESA=? AND TRABAJOANEXOIEMPRESA=? AND DIRECCIONEMPRESA=? AND PLANTILLATOTALEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND MUNOICIPIOEMPRESA=? AND EMAILEMPRESA=? AND HTTPEMPRESA=? AND FAXEMPRESA=? AND TELEFONOEMPRESA=? AND DOMICILIODIRECCIONCENTRO=? AND MUNICIPIODIRECCIONCENTRO=? AND THDIRECCIONCENTRO=? AND NUMEROAPERTURA=? AND TIPMPR1=? AND TIPMPR2=? AND NOMMPR1=? AND NOMMPR2=? AND TOPSEG1=? AND TOPSEG2=? AND TOPHIG1=? AND TOPHIG2=? AND TOPER1=? AND TOPER2=? AND TOPVIG1=? AND TOPVIG2=? AND TIPRIE1=? AND TIPRIE2=? AND NOMRIE1=? AND NOMRIE2=? AND AUDITORIANOREALIZADA=? AND AUDITORIAREALIZADA=? AND FECHAULTIMAREALIZACION=? AND EMPRESAAUDITORA=?";
		this.jdbcTemplate.update(query, vfichaos2.getNumexp(),
				vfichaos2.getRazonsocial(),
				vfichaos2.getNumerodocumentoempresa(),
				vfichaos2.getCenaedescripcion(),
				vfichaos2.getActividadeconomica(),
				vfichaos2.getNorealizatrabajoanexoiempresa(),
				vfichaos2.getRealizatrabajoanexoiempresa(),
				vfichaos2.getTrabajoanexoiempresa(),
				vfichaos2.getDireccionempresa(),
				vfichaos2.getPlantillatotalempresa(),
				vfichaos2.getTerritorioempresa(), vfichaos2.getCp(),
				vfichaos2.getMunoicipioempresa(), vfichaos2.getEmailempresa(),
				vfichaos2.getHttpempresa(), vfichaos2.getFaxempresa(),
				vfichaos2.getTelefonoempresa(),
				vfichaos2.getDomiciliodireccioncentro(),
				vfichaos2.getMunicipiodireccioncentro(),
				vfichaos2.getThdireccioncentro(),
				vfichaos2.getNumeroapertura(), vfichaos2.getTipmpr1(),
				vfichaos2.getTipmpr2(), vfichaos2.getNommpr1(),
				vfichaos2.getNommpr2(), vfichaos2.getTopseg1(),
				vfichaos2.getTopseg2(), vfichaos2.getTophig1(),
				vfichaos2.getTophig2(), vfichaos2.getToper1(),
				vfichaos2.getToper2(), vfichaos2.getTopvig1(),
				vfichaos2.getTopvig2(), vfichaos2.getTiprie1(),
				vfichaos2.getTiprie2(), vfichaos2.getNomrie1(),
				vfichaos2.getNomrie2(), vfichaos2.getAuditorianorealizada(),
				vfichaos2.getAuditoriarealizada(),
				vfichaos2.getFechaultimarealizacion(),
				vfichaos2.getEmpresaauditora());
	}

	/**
	 * Finds a list of rows in the VfichaOs2 table.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VfichaOs2>
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaOs2> findAll(VfichaOs2 vfichaos2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.RAZONSOCIAL RAZONSOCIAL,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.CENAEDESCRIPCION CENAEDESCRIPCION,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA,t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA,t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA,t1.EMAILEMPRESA EMAILEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO,t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO,t1.THDIRECCIONCENTRO THDIRECCIONCENTRO,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.TIPMPR1 TIPMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR1 NOMMPR1,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPER1 TOPER1,t1.TOPER2 TOPER2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE1 NOMRIE1,t1.NOMRIE2 NOMRIE2,t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA,t1.AUDITORIAREALIZADA AUDITORIAREALIZADA,t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION,t1.EMPRESAAUDITORA EMPRESAAUDITORA ");
		query.append("FROM VFICHA_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaOs2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VfichaOs2 table using like.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VfichaOs2>
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaOs2> findAllLike(VfichaOs2 vfichaos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.RAZONSOCIAL RAZONSOCIAL,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.CENAEDESCRIPCION CENAEDESCRIPCION,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA,t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA,t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA,t1.EMAILEMPRESA EMAILEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO,t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO,t1.THDIRECCIONCENTRO THDIRECCIONCENTRO,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.TIPMPR1 TIPMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR1 NOMMPR1,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPER1 TOPER1,t1.TOPER2 TOPER2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE1 NOMRIE1,t1.NOMRIE2 NOMRIE2,t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA,t1.AUDITORIAREALIZADA AUDITORIAREALIZADA,t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION,t1.EMPRESAAUDITORA EMPRESAAUDITORA ");
		query.append("FROM VFICHA_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaOs2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VfichaOs2 table.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  Long
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VfichaOs2 vfichaos2) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VfichaOs2 table using like.
	 * 
	 *  vfichaos2
	 *            VfichaOs2
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VfichaOs2 vfichaos2, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VfichaOs2 selected for rup_table.
	 * 
	 *  vfichaos2            VfichaOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VfichaOs2>>
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaOs2>> reorderSelection(VfichaOs2 vfichaos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.RAZONSOCIAL RAZONSOCIAL,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.CENAEDESCRIPCION CENAEDESCRIPCION,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA,t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA,t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA,t1.EMAILEMPRESA EMAILEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO,t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO,t1.THDIRECCIONCENTRO THDIRECCIONCENTRO,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.TIPMPR1 TIPMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR1 NOMMPR1,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPER1 TOPER1,t1.TOPER2 TOPER2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE1 NOMRIE1,t1.NOMRIE2 NOMRIE2,t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA,t1.AUDITORIAREALIZADA AUDITORIAREALIZADA,t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION,t1.EMPRESAAUDITORA EMPRESAAUDITORA ");
		// FROM
		query.append("FROM VFICHA_OS2 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VfichaOs2.class,
						filterParamList,
						"NUMEXP,RAZONSOCIAL,NUMERODOCUMENTOEMPRESA,CENAEDESCRIPCION,ACTIVIDADECONOMICA,NOREALIZATRABAJOANEXOIEMPRESA,REALIZATRABAJOANEXOIEMPRESA,TRABAJOANEXOIEMPRESA,DIRECCIONEMPRESA,PLANTILLATOTALEMPRESA,TERRITORIOEMPRESA,CP,MUNOICIPIOEMPRESA,EMAILEMPRESA,HTTPEMPRESA,FAXEMPRESA,TELEFONOEMPRESA,DOMICILIODIRECCIONCENTRO,MUNICIPIODIRECCIONCENTRO,THDIRECCIONCENTRO,NUMEROAPERTURA,TIPMPR1,TIPMPR2,NOMMPR1,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPER1,TOPER2,TOPVIG1,TOPVIG2,TIPRIE1,TIPRIE2,NOMRIE1,NOMRIE2,AUDITORIANOREALIZADA,AUDITORIAREALIZADA,FECHAULTIMAREALIZACION,EMPRESAAUDITORA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VfichaOs2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VfichaOs2
	 *  searchParams            VfichaOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VfichaOs2>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaOs2>> search(VfichaOs2 filterParams,
			VfichaOs2 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.RAZONSOCIAL RAZONSOCIAL,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.CENAEDESCRIPCION CENAEDESCRIPCION,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA,t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA,t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA,t1.EMAILEMPRESA EMAILEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO,t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO,t1.THDIRECCIONCENTRO THDIRECCIONCENTRO,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.TIPMPR1 TIPMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR1 NOMMPR1,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPER1 TOPER1,t1.TOPER2 TOPER2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE1 NOMRIE1,t1.NOMRIE2 NOMRIE2,t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA,t1.AUDITORIAREALIZADA AUDITORIAREALIZADA,t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION,t1.EMPRESAAUDITORA EMPRESAAUDITORA ");
		// FROM
		query.append("FROM VFICHA_OS2 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VfichaOs2.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXP,RAZONSOCIAL,NUMERODOCUMENTOEMPRESA,CENAEDESCRIPCION,ACTIVIDADECONOMICA,NOREALIZATRABAJOANEXOIEMPRESA,REALIZATRABAJOANEXOIEMPRESA,TRABAJOANEXOIEMPRESA,DIRECCIONEMPRESA,PLANTILLATOTALEMPRESA,TERRITORIOEMPRESA,CP,MUNOICIPIOEMPRESA,EMAILEMPRESA,HTTPEMPRESA,FAXEMPRESA,TELEFONOEMPRESA,DOMICILIODIRECCIONCENTRO,MUNICIPIODIRECCIONCENTRO,THDIRECCIONCENTRO,NUMEROAPERTURA,TIPMPR1,TIPMPR2,NOMMPR1,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPER1,TOPER2,TOPVIG1,TOPVIG2,TIPRIE1,TIPRIE2,NOMRIE1,NOMRIE2,AUDITORIANOREALIZADA,AUDITORIAREALIZADA,FECHAULTIMAREALIZACION,EMPRESAAUDITORA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VfichaOs2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervfichaos2            VfichaOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervfichaos2 the filtervfichaos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VfichaOs2 filtervfichaos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.RAZONSOCIAL RAZONSOCIAL,t1.NUMERODOCUMENTOEMPRESA NUMERODOCUMENTOEMPRESA,t1.CENAEDESCRIPCION CENAEDESCRIPCION,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.NOREALIZATRABAJOANEXOIEMPRESA NOREALIZATRABAJOANEXOIEMPRESA,t1.REALIZATRABAJOANEXOIEMPRESA REALIZATRABAJOANEXOIEMPRESA,t1.TRABAJOANEXOIEMPRESA TRABAJOANEXOIEMPRESA,t1.DIRECCIONEMPRESA DIRECCIONEMPRESA,t1.PLANTILLATOTALEMPRESA PLANTILLATOTALEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.MUNOICIPIOEMPRESA MUNOICIPIOEMPRESA,t1.EMAILEMPRESA EMAILEMPRESA,t1.HTTPEMPRESA HTTPEMPRESA,t1.FAXEMPRESA FAXEMPRESA,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.DOMICILIODIRECCIONCENTRO DOMICILIODIRECCIONCENTRO,t1.MUNICIPIODIRECCIONCENTRO MUNICIPIODIRECCIONCENTRO,t1.THDIRECCIONCENTRO THDIRECCIONCENTRO,t1.NUMEROAPERTURA NUMEROAPERTURA,t1.TIPMPR1 TIPMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR1 NOMMPR1,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPER1 TOPER1,t1.TOPER2 TOPER2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE1 NOMRIE1,t1.NOMRIE2 NOMRIE2,t1.AUDITORIANOREALIZADA AUDITORIANOREALIZADA,t1.AUDITORIAREALIZADA AUDITORIAREALIZADA,t1.FECHAULTIMAREALIZACION FECHAULTIMAREALIZACION,t1.EMPRESAAUDITORA EMPRESAAUDITORA ");
		// FROM
		query.append("FROM VFICHA_OS2 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervfichaos2,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VfichaOs2.class,
						query,
						params,
						"NUMEXP,RAZONSOCIAL,NUMERODOCUMENTOEMPRESA,CENAEDESCRIPCION,ACTIVIDADECONOMICA,NOREALIZATRABAJOANEXOIEMPRESA,REALIZATRABAJOANEXOIEMPRESA,TRABAJOANEXOIEMPRESA,DIRECCIONEMPRESA,PLANTILLATOTALEMPRESA,TERRITORIOEMPRESA,CP,MUNOICIPIOEMPRESA,EMAILEMPRESA,HTTPEMPRESA,FAXEMPRESA,TELEFONOEMPRESA,DOMICILIODIRECCIONCENTRO,MUNICIPIODIRECCIONCENTRO,THDIRECCIONCENTRO,NUMEROAPERTURA,TIPMPR1,TIPMPR2,NOMMPR1,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPER1,TOPER2,TOPVIG1,TOPVIG2,TIPRIE1,TIPRIE2,NOMRIE1,NOMRIE2,AUDITORIANOREALIZADA,AUDITORIAREALIZADA,FECHAULTIMAREALIZACION,EMPRESAAUDITORA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaOs2 entity.
	 * 
	 *  vfichaos2            VfichaOs2 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VfichaOs2 vfichaos2) {

		StringBuilder where = new StringBuilder(
				VfichaOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaos2 != null && vfichaos2.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vfichaos2.getNumexp());
		}
		if (vfichaos2 != null && vfichaos2.getRazonsocial() != null) {
			where.append(" AND t1.RAZONSOCIAL = ?");
			params.add(vfichaos2.getRazonsocial());
		}
		if (vfichaos2 != null && vfichaos2.getNumerodocumentoempresa() != null) {
			where.append(" AND t1.NUMERODOCUMENTOEMPRESA = ?");
			params.add(vfichaos2.getNumerodocumentoempresa());
		}
		if (vfichaos2 != null && vfichaos2.getCenaedescripcion() != null) {
			where.append(" AND t1.CENAEDESCRIPCION = ?");
			params.add(vfichaos2.getCenaedescripcion());
		}
		if (vfichaos2 != null && vfichaos2.getActividadeconomica() != null) {
			where.append(" AND t1.ACTIVIDADECONOMICA = ?");
			params.add(vfichaos2.getActividadeconomica());
		}
		if (vfichaos2 != null
				&& vfichaos2.getNorealizatrabajoanexoiempresa() != null) {
			where.append(" AND t1.NOREALIZATRABAJOANEXOIEMPRESA = ?");
			params.add(vfichaos2.getNorealizatrabajoanexoiempresa());
		}
		if (vfichaos2 != null
				&& vfichaos2.getRealizatrabajoanexoiempresa() != null) {
			where.append(" AND t1.REALIZATRABAJOANEXOIEMPRESA = ?");
			params.add(vfichaos2.getRealizatrabajoanexoiempresa());
		}
		if (vfichaos2 != null && vfichaos2.getTrabajoanexoiempresa() != null) {
			where.append(" AND t1.TRABAJOANEXOIEMPRESA = ?");
			params.add(vfichaos2.getTrabajoanexoiempresa());
		}
		if (vfichaos2 != null && vfichaos2.getDireccionempresa() != null) {
			where.append(" AND t1.DIRECCIONEMPRESA = ?");
			params.add(vfichaos2.getDireccionempresa());
		}
		if (vfichaos2 != null && vfichaos2.getPlantillatotalempresa() != null) {
			where.append(" AND t1.PLANTILLATOTALEMPRESA = ?");
			params.add(vfichaos2.getPlantillatotalempresa());
		}
		if (vfichaos2 != null && vfichaos2.getTerritorioempresa() != null) {
			where.append(" AND t1.TERRITORIOEMPRESA = ?");
			params.add(vfichaos2.getTerritorioempresa());
		}
		if (vfichaos2 != null && vfichaos2.getCp() != null) {
			where.append(" AND t1.CP = ?");
			params.add(vfichaos2.getCp());
		}
		if (vfichaos2 != null && vfichaos2.getMunoicipioempresa() != null) {
			where.append(" AND t1.MUNOICIPIOEMPRESA = ?");
			params.add(vfichaos2.getMunoicipioempresa());
		}
		if (vfichaos2 != null && vfichaos2.getEmailempresa() != null) {
			where.append(" AND t1.EMAILEMPRESA = ?");
			params.add(vfichaos2.getEmailempresa());
		}
		if (vfichaos2 != null && vfichaos2.getHttpempresa() != null) {
			where.append(" AND t1.HTTPEMPRESA = ?");
			params.add(vfichaos2.getHttpempresa());
		}
		if (vfichaos2 != null && vfichaos2.getFaxempresa() != null) {
			where.append(" AND t1.FAXEMPRESA = ?");
			params.add(vfichaos2.getFaxempresa());
		}
		if (vfichaos2 != null && vfichaos2.getTelefonoempresa() != null) {
			where.append(" AND t1.TELEFONOEMPRESA = ?");
			params.add(vfichaos2.getTelefonoempresa());
		}
		if (vfichaos2 != null
				&& vfichaos2.getDomiciliodireccioncentro() != null) {
			where.append(" AND t1.DOMICILIODIRECCIONCENTRO = ?");
			params.add(vfichaos2.getDomiciliodireccioncentro());
		}
		if (vfichaos2 != null
				&& vfichaos2.getMunicipiodireccioncentro() != null) {
			where.append(" AND t1.MUNICIPIODIRECCIONCENTRO = ?");
			params.add(vfichaos2.getMunicipiodireccioncentro());
		}
		if (vfichaos2 != null && vfichaos2.getThdireccioncentro() != null) {
			where.append(" AND t1.THDIRECCIONCENTRO = ?");
			params.add(vfichaos2.getThdireccioncentro());
		}
		if (vfichaos2 != null && vfichaos2.getNumeroapertura() != null) {
			where.append(" AND t1.NUMEROAPERTURA = ?");
			params.add(vfichaos2.getNumeroapertura());
		}
		if (vfichaos2 != null && vfichaos2.getTipmpr1() != null) {
			where.append(" AND t1.TIPMPR1 = ?");
			params.add(vfichaos2.getTipmpr1());
		}
		if (vfichaos2 != null && vfichaos2.getTipmpr2() != null) {
			where.append(" AND t1.TIPMPR2 = ?");
			params.add(vfichaos2.getTipmpr2());
		}
		if (vfichaos2 != null && vfichaos2.getNommpr1() != null) {
			where.append(" AND t1.NOMMPR1 = ?");
			params.add(vfichaos2.getNommpr1());
		}
		if (vfichaos2 != null && vfichaos2.getNommpr2() != null) {
			where.append(" AND t1.NOMMPR2 = ?");
			params.add(vfichaos2.getNommpr2());
		}
		if (vfichaos2 != null && vfichaos2.getTopseg1() != null) {
			where.append(" AND t1.TOPSEG1 = ?");
			params.add(vfichaos2.getTopseg1());
		}
		if (vfichaos2 != null && vfichaos2.getTopseg2() != null) {
			where.append(" AND t1.TOPSEG2 = ?");
			params.add(vfichaos2.getTopseg2());
		}
		if (vfichaos2 != null && vfichaos2.getTophig1() != null) {
			where.append(" AND t1.TOPHIG1 = ?");
			params.add(vfichaos2.getTophig1());
		}
		if (vfichaos2 != null && vfichaos2.getTophig2() != null) {
			where.append(" AND t1.TOPHIG2 = ?");
			params.add(vfichaos2.getTophig2());
		}
		if (vfichaos2 != null && vfichaos2.getToper1() != null) {
			where.append(" AND t1.TOPER1 = ?");
			params.add(vfichaos2.getToper1());
		}
		if (vfichaos2 != null && vfichaos2.getToper2() != null) {
			where.append(" AND t1.TOPER2 = ?");
			params.add(vfichaos2.getToper2());
		}
		if (vfichaos2 != null && vfichaos2.getTopvig1() != null) {
			where.append(" AND t1.TOPVIG1 = ?");
			params.add(vfichaos2.getTopvig1());
		}
		if (vfichaos2 != null && vfichaos2.getTopvig2() != null) {
			where.append(" AND t1.TOPVIG2 = ?");
			params.add(vfichaos2.getTopvig2());
		}
		if (vfichaos2 != null && vfichaos2.getTiprie1() != null) {
			where.append(" AND t1.TIPRIE1 = ?");
			params.add(vfichaos2.getTiprie1());
		}
		if (vfichaos2 != null && vfichaos2.getTiprie2() != null) {
			where.append(" AND t1.TIPRIE2 = ?");
			params.add(vfichaos2.getTiprie2());
		}
		if (vfichaos2 != null && vfichaos2.getNomrie1() != null) {
			where.append(" AND t1.NOMRIE1 = ?");
			params.add(vfichaos2.getNomrie1());
		}
		if (vfichaos2 != null && vfichaos2.getNomrie2() != null) {
			where.append(" AND t1.NOMRIE2 = ?");
			params.add(vfichaos2.getNomrie2());
		}
		if (vfichaos2 != null && vfichaos2.getAuditorianorealizada() != null) {
			where.append(" AND t1.AUDITORIANOREALIZADA = ?");
			params.add(vfichaos2.getAuditorianorealizada());
		}
		if (vfichaos2 != null && vfichaos2.getAuditoriarealizada() != null) {
			where.append(" AND t1.AUDITORIAREALIZADA = ?");
			params.add(vfichaos2.getAuditoriarealizada());
		}
		if (vfichaos2 != null && vfichaos2.getFechaultimarealizacion() != null) {
			where.append(" AND t1.FECHAULTIMAREALIZACION = ?");
			params.add(vfichaos2.getFechaultimarealizacion());
		}
		if (vfichaos2 != null && vfichaos2.getEmpresaauditora() != null) {
			where.append(" AND t1.EMPRESAAUDITORA = ?");
			params.add(vfichaos2.getEmpresaauditora());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaOs2 entity.
	 * 
	 *  vfichaos2            VfichaOs2 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vfichaos2 the vfichaos 2
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VfichaOs2 vfichaos2,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VfichaOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaos2 != null && vfichaos2.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNumexp().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getRazonsocial() != null) {
			where.append(" AND UPPER(t1.RAZONSOCIAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getRazonsocial().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getRazonsocial().toUpperCase() + "%");
			}
			where.append(" AND t1.RAZONSOCIAL IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNumerodocumentoempresa() != null) {
			where.append(" AND UPPER(t1.NUMERODOCUMENTOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNumerodocumentoempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos2.getNumerodocumentoempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMERODOCUMENTOEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getCenaedescripcion() != null) {
			where.append(" AND UPPER(t1.CENAEDESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getCenaedescripcion().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getCenaedescripcion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CENAEDESCRIPCION IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getActividadeconomica() != null) {
			where.append(" AND UPPER(t1.ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getActividadeconomica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos2.getActividadeconomica().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (vfichaos2 != null
				&& vfichaos2.getNorealizatrabajoanexoiempresa() != null) {
			where.append(" AND UPPER(t1.NOREALIZATRABAJOANEXOIEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNorealizatrabajoanexoiempresa()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vfichaos2.getNorealizatrabajoanexoiempresa()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.NOREALIZATRABAJOANEXOIEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null
				&& vfichaos2.getRealizatrabajoanexoiempresa() != null) {
			where.append(" AND UPPER(t1.REALIZATRABAJOANEXOIEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getRealizatrabajoanexoiempresa()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vfichaos2.getRealizatrabajoanexoiempresa()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.REALIZATRABAJOANEXOIEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTrabajoanexoiempresa() != null) {
			where.append(" AND UPPER(t1.TRABAJOANEXOIEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTrabajoanexoiempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos2.getTrabajoanexoiempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRABAJOANEXOIEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getDireccionempresa() != null) {
			where.append(" AND UPPER(t1.DIRECCIONEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getDireccionempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getDireccionempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCIONEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getPlantillatotalempresa() != null) {
			where.append(" AND t1.PLANTILLATOTALEMPRESA = ?");
			params.add(vfichaos2.getPlantillatotalempresa());
		}
		if (vfichaos2 != null && vfichaos2.getTerritorioempresa() != null) {
			where.append(" AND UPPER(t1.TERRITORIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTerritorioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTerritorioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIOEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getCp() != null) {
			where.append(" AND UPPER(t1.CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getCp().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getCp().toUpperCase() + "%");
			}
			where.append(" AND t1.CP IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getMunoicipioempresa() != null) {
			where.append(" AND UPPER(t1.MUNOICIPIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getMunoicipioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getMunoicipioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNOICIPIOEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getEmailempresa() != null) {
			where.append(" AND UPPER(t1.EMAILEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getEmailempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getEmailempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMAILEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getHttpempresa() != null) {
			where.append(" AND UPPER(t1.HTTPEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getHttpempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getHttpempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getFaxempresa() != null) {
			where.append(" AND UPPER(t1.FAXEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getFaxempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getFaxempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTelefonoempresa() != null) {
			where.append(" AND UPPER(t1.TELEFONOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTelefonoempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTelefonoempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TELEFONOEMPRESA IS NOT NULL");
		}
		if (vfichaos2 != null
				&& vfichaos2.getDomiciliodireccioncentro() != null) {
			where.append(" AND UPPER(t1.DOMICILIODIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getDomiciliodireccioncentro()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vfichaos2.getDomiciliodireccioncentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DOMICILIODIRECCIONCENTRO IS NOT NULL");
		}
		if (vfichaos2 != null
				&& vfichaos2.getMunicipiodireccioncentro() != null) {
			where.append(" AND UPPER(t1.MUNICIPIODIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getMunicipiodireccioncentro()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ vfichaos2.getMunicipiodireccioncentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIODIRECCIONCENTRO IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getThdireccioncentro() != null) {
			where.append(" AND UPPER(t1.THDIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getThdireccioncentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getThdireccioncentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.THDIRECCIONCENTRO IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNumeroapertura() != null) {
			where.append(" AND UPPER(t1.NUMEROAPERTURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNumeroapertura().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNumeroapertura().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMEROAPERTURA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTipmpr1() != null) {
			where.append(" AND UPPER(t1.TIPMPR1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTipmpr1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTipmpr1().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPMPR1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTipmpr2() != null) {
			where.append(" AND UPPER(t1.TIPMPR2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTipmpr2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTipmpr2().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPMPR2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNommpr1() != null) {
			where.append(" AND UPPER(t1.NOMMPR1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNommpr1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNommpr1().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMMPR1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNommpr2() != null) {
			where.append(" AND UPPER(t1.NOMMPR2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNommpr2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNommpr2().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMMPR2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTopseg1() != null) {
			where.append(" AND UPPER(t1.TOPSEG1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTopseg1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTopseg1().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPSEG1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTopseg2() != null) {
			where.append(" AND UPPER(t1.TOPSEG2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTopseg2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTopseg2().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPSEG2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTophig1() != null) {
			where.append(" AND UPPER(t1.TOPHIG1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTophig1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTophig1().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPHIG1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTophig2() != null) {
			where.append(" AND UPPER(t1.TOPHIG2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTophig2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTophig2().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPHIG2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getToper1() != null) {
			where.append(" AND UPPER(t1.TOPER1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getToper1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getToper1().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPER1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getToper2() != null) {
			where.append(" AND UPPER(t1.TOPER2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getToper2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getToper2().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPER2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTopvig1() != null) {
			where.append(" AND UPPER(t1.TOPVIG1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTopvig1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTopvig1().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPVIG1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTopvig2() != null) {
			where.append(" AND UPPER(t1.TOPVIG2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTopvig2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTopvig2().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPVIG2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTiprie1() != null) {
			where.append(" AND UPPER(t1.TIPRIE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTiprie1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTiprie1().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPRIE1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getTiprie2() != null) {
			where.append(" AND UPPER(t1.TIPRIE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getTiprie2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getTiprie2().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPRIE2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNomrie1() != null) {
			where.append(" AND UPPER(t1.NOMRIE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNomrie1().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNomrie1().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRIE1 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getNomrie2() != null) {
			where.append(" AND UPPER(t1.NOMRIE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getNomrie2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getNomrie2().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRIE2 IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getAuditorianorealizada() != null) {
			where.append(" AND UPPER(t1.AUDITORIANOREALIZADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getAuditorianorealizada().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos2.getAuditorianorealizada().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AUDITORIANOREALIZADA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getAuditoriarealizada() != null) {
			where.append(" AND UPPER(t1.AUDITORIAREALIZADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getAuditoriarealizada().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaos2.getAuditoriarealizada().toUpperCase() + "%");
			}
			where.append(" AND t1.AUDITORIAREALIZADA IS NOT NULL");
		}
		if (vfichaos2 != null && vfichaos2.getFechaultimarealizacion() != null) {
			where.append(" AND t1.FECHAULTIMAREALIZACION = ?");
			params.add(vfichaos2.getFechaultimarealizacion());
		}
		if (vfichaos2 != null && vfichaos2.getEmpresaauditora() != null) {
			where.append(" AND UPPER(t1.EMPRESAAUDITORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaos2.getEmpresaauditora().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaos2.getEmpresaauditora().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMPRESAAUDITORA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
